<?php

namespace App\Models;

use App\Trait\Imageable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphMany;

class Package extends Model
{
    /** @use HasFactory<\Database\Factories\PackageFactory> */
    use HasFactory, Imageable;

    protected $fillable = [
        'category_id',
        'destination_id',
        'agent_id',
        'name',
        'slug',
        'duration',
        'adult_price',
        'child_price',
        'infant_price',
        'max_people',
        'min_people',
        'video',
        'description',
        'inclusions',
        'exclusions',
        'we_expect',
        'start_point',
        'end_point',
        'pickup_point',
        'status',
        'start_date',
        'published',
        'published_at',
        'featured',
        'published_by',
    ];

    public function casts(): array
    {
        return [
            'status' => 'boolean',
            'adult_price' => 'integer',
            'child_price' => 'integer',
            'infant_price' => 'integer',
            'max_people' => 'integer',
            'min_people' => 'integer',
            'inclusions' => 'array',
            'exclusions' => 'array',
            'we_expect' => 'array',
            'start_date' => 'datetime',
            'published' => 'boolean',
            'published_at' => 'datetime',
            'featured' => 'boolean',
        ];
    }

    public function category(): BelongsTo
    {
        return $this->belongsTo(Category::class)->getType('package');
    }

    public function destination(): BelongsTo
    {
        return $this->belongsTo(Destination::class);
    }

    public function agent(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function bookings(): HasMany
    {
        return $this->hasMany(Booking::class);
    }

    public function reviews(): MorphMany
    {
        return $this->morphMany(Review::class, 'reviewable');
    }

    // Scope
    public function scopePublished($query)
    {
        return $query->where('published', true);
    }

    public function scopeFeatured($query)
    {
        return $query->where('featured', true);
    }

    public function scopeActive($query)
    {
        return $query->where('status', true);
    }
}
